	function hdlspec = hdlfirtb(name, firspec, refspec)
	%hdlspec = hdlfirtb(name, firspec, refspec)
	%
	%Generates a testbench for an FIR filter:
	%  name_tb - testbench for verifying the function of the filter. The
	%    The bit-level specification firspec and the high-level
	%    specification refspec can be generated with hdlfir and hdlfirref,
	%    respectively. Stimuli files generated by genfirstim are also
	%    expected to be found in the same directory.
	%
	%Arguments:
	%  name - name of the testbench
	%  firspec - bit-level filter specification
	%  refspec - reference filter specification
	%
	%Returns:
	%  hdlspec - HDL specification structure
	
	%Copyright 2008, 2010 Anton Blad
	%
	%This file is part of firgen.
	%
	%firgen is free software: you can redistribute it and/or modify
	%it under the terms of the GNU General Public License as published by
	%the Free Software Foundation, either version 3 of the License, or
	%(at your option) any later version.
	%
	%firgen is distributed in the hope that it will be useful,
	%but WITHOUT ANY WARRANTY; without even the implied warranty of
	%MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	%GNU General Public License for more details.
	%
	%You should have received a copy of the GNU General Public License
	%along with firgen.  If not, see <http://www.gnu.org/licenses/>
	
	fircomp = hdlgenfindcomponent(firspec.components, firspec.top);
	refcomp = hdlgenfindcomponent(refspec.components, refspec.top);
	
	leaf.class = 0;
	fircomp.arch = leaf;
	refcomp.arch = leaf;
	
	hdlspec.top = name;
	hdlspec.components = [];
	hdlspec.components = [hdlspec.components; hdlcompiface('clkgen')];
	hdlspec.components = [hdlspec.components; hdlcompiface('stimgen')];
	hdlspec.components = [hdlspec.components; hdlcompiface('cmp')];
	hdlspec.components = [hdlspec.components; fircomp];
	hdlspec.components = [hdlspec.components; refcomp];
	
	inputs = fircomp.iface.inputs;
	outputs = fircomp.iface.outputs;
	
	comp.iface.name = name;
	comp.iface.generics = [];
	comp.iface.inputs = [];
	comp.iface.outputs = [];
	comp.iface.globals = [];
	
	comp.arch.class = 2;
	comp.arch.components = {'clkgen', 'stimgen', 'cmp', fircomp.iface.name, refcomp.iface.name};
	comp.arch.signals = struct('name', {}, 'type', {});
	comp.arch.instances = struct('type', {}, 'generics', {}, 'inputs', {}, 'outputs', {});
	comp.arch.assignments = struct('class', {}, 'dest', {}, 'destmod', {}, 'src', {});
	
	ksig = 0;
	kinst = 0;
	kass = 0;
	
	ksig = ksig + 1;
	comp.arch.signals(ksig) = hdlsignal('clk', 0);
	ksig = ksig + 1;
	comp.arch.signals(ksig) = hdlsignal('reset', 0);
	
	kinst = kinst + 1;
	comp.arch.instances(kinst) = hdlinst('clkgen', ...
		hdlmap('period', 20, 0, 'timens'), [], ...
		[hdlmap('clk', 'clk'); hdlmap('reset', 'reset')]);
	
	for input = inputs
		ksig = ksig + 1;
		comp.arch.signals(ksig) = hdlsignal(input.name, 1, input.type.width.val);
		kinst = kinst + 1;
		comp.arch.instances(kinst) = hdlinst('stimgen', ...
			[hdlmap('stimfn', strcat(input.name, '.stim'), 0);
			 hdlmap('wordlength', input.type.width.val)], [], ...
			hdlmap('data', input.name));
	end
	
	inmap = [];
	for input = inputs
		inmap = [inmap;hdlmap(input.name, input.name)];
	end
	
	firoutmap = [];
	refoutmap = [];
	for output = outputs
		firoutmap = [firoutmap;hdlmap(output.name, strcat('fir_', output.name))];
		refoutmap = [refoutmap;hdlmap(output.name, strcat('ref_', output.name))];
	end
	
	kinst = kinst + 1;
	comp.arch.instances(kinst) = hdlinst(fircomp.iface.name, [], inmap, firoutmap);
	
	kinst = kinst + 1;
	comp.arch.instances(kinst) = hdlinst(refcomp.iface.name, [], inmap, refoutmap);
	
	for output = outputs
		ksig = ksig + 1;
		comp.arch.signals(ksig) = hdlsignal(strcat('fir_', output.name), 1, output.type.width.val);
	end
	
	for output = outputs
		ksig = ksig + 1;
		comp.arch.signals(ksig) = hdlsignal(strcat('ref_', output.name), 1, output.type.width.val);
	end
	
	for output = outputs
		ksig = ksig + 1;
		comp.arch.signals(ksig) = hdlsignal(strcat('check_', output.name), 0);
	end
	
	for output = outputs
		kinst = kinst + 1;
		comp.arch.instances(kinst) = hdlinst('cmp', ...
			hdlmap('wordlength', output.type.width.val), ...
			[hdlmap('x1', strcat('fir_', output.name)); hdlmap('x2', strcat('ref_', output.name))], ...
			hdlmap('y', strcat('check_', output.name)));
	end
	
	hdlspec.components = [hdlspec.components; comp];
	
